/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.anttask;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.junitee.anttask.FormatterElement;
import org.junitee.anttask.JUnitEEResultFormatter;
import org.junitee.anttask.JUnitEETest;
import org.junitee.anttask.SummaryResultFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JUnitEETask
extends Task {
    private String url;
    private boolean threaded = true;
    private Vector tests = new Vector();
    private boolean printSummary = false;
    private Vector formatters = new Vector();

    public void setUrl(String url) {
        this.url = url;
    }

    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    public void setFiltertrace(boolean filtertrace) {
        Enumeration enumeration = this.tests.elements();
        while (enumeration.hasMoreElements()) {
            ((JUnitEETest)enumeration.nextElement()).setFiltertrace(filtertrace);
        }
    }

    public void setHaltonfailure(boolean value) {
        Enumeration enumeration = this.tests.elements();
        while (enumeration.hasMoreElements()) {
            ((JUnitEETest)enumeration.nextElement()).setHaltonfailure(value);
        }
    }

    public void setHaltonerror(boolean value) {
        Enumeration enumeration = this.tests.elements();
        while (enumeration.hasMoreElements()) {
            ((JUnitEETest)enumeration.nextElement()).setHaltonerror(value);
        }
    }

    public void setPrintsummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public void setErrorproperty(String value) {
        Enumeration enumeration = this.tests.elements();
        while (enumeration.hasMoreElements()) {
            ((JUnitEETest)enumeration.nextElement()).setErrorproperty(value);
        }
    }

    public void setFailureproperty(String value) {
        Enumeration enumeration = this.tests.elements();
        while (enumeration.hasMoreElements()) {
            ((JUnitEETest)enumeration.nextElement()).setFailureproperty(value);
        }
    }

    public JUnitEETest createTest() {
        JUnitEETest test = new JUnitEETest();
        this.tests.add(test);
        return test;
    }

    public void addFormatter(FormatterElement formatter) {
        this.formatters.addElement(formatter);
    }

    public void execute() throws BuildException {
        if (this.url == null) {
            throw new BuildException("You must specify the url attribute", this.location);
        }
        try {
            new URL(this.url);
        }
        catch (MalformedURLException e) {
            throw new BuildException(this.url + " is no valid URL");
        }
        Enumeration enumeration = this.tests.elements();
        while (enumeration.hasMoreElements()) {
            JUnitEETest test = (JUnitEETest)enumeration.nextElement();
            if (!test.shouldExecute(this.getProject())) continue;
            this.execute(test);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(JUnitEETest test) throws BuildException {
        boolean done;
        String sessionCookie;
        URLConnection con;
        URL requestUrl;
        InputStream in;
        block28: {
            StringBuffer arguments = new StringBuffer();
            arguments.append(this.url).append("?output=xml");
            if (this.threaded) {
                this.log("Threaded mode", 4);
                arguments.append("&thread=true");
            }
            if (test.getResource() != null) {
                arguments.append("&resource=").append(test.getResource());
            }
            if (test.getRunall()) {
                arguments.append("&all=true");
            } else {
                if (test.getName() == null) throw new BuildException("You must specify the test name or runall attribute", this.location);
                arguments.append("&suite=").append(URLEncoder.encode(test.getName()));
            }
            if (!test.getFiltertrace()) {
                arguments.append("&filterTrace=false");
            }
            in = null;
            try {
                try {
                    int index;
                    requestUrl = new URL(arguments.toString());
                    con = requestUrl.openConnection();
                    sessionCookie = con.getHeaderField("Set-Cookie");
                    this.log("Session cookie : " + sessionCookie, 4);
                    if (sessionCookie != null && (index = sessionCookie.indexOf(59)) != -1) {
                        sessionCookie = sessionCookie.substring(0, index);
                    }
                    in = con.getInputStream();
                    done = this.parseResult(in, test);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.log("Failed to execute test: " + e, 0);
                    throw new BuildException((Throwable)e);
                }
                Object var10_15 = null;
                if (in == null) break block28;
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            in.close();
        }
        try {
            while (!done) {
                try {
                    this.log("Sleeping ... ", 4);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.log("Get xml again using URL " + requestUrl, 4);
                con = requestUrl.openConnection();
                if (sessionCookie != null) {
                    con.setRequestProperty("Cookie", sessionCookie);
                }
                in = con.getInputStream();
                try {
                    done = this.parseResult(in, test);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            return;
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            this.log("Failed to execute test: " + e, 0);
            throw new BuildException((Throwable)e);
        }
    }

    private boolean parseResult(InputStream in, JUnitEETest test) throws Exception {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        byte[] buffer = this.readInput(in);
        try {
            document = builder.parse(new ByteArrayInputStream(buffer));
        }
        catch (SAXException e) {
            this.log("Invalid xml:\n " + new String(buffer), 0);
            throw new BuildException("Unable to parse test result (no valid xml).");
        }
        Element root = document.getDocumentElement();
        if (root.getAttributeNode("unfinished") != null) {
            this.log(String.valueOf(root.getAttributeNode("unfinished")), 4);
            return false;
        }
        root.normalize();
        NodeList testcases = root.getElementsByTagName("testsuite");
        Vector resultFormatters = this.createFormatters(test);
        for (int i = 0; i < testcases.getLength(); ++i) {
            Node node = testcases.item(i);
            NamedNodeMap attributes = node.getAttributes();
            String testClass = attributes.getNamedItem("name").getNodeValue();
            String testPkg = attributes.getNamedItem("package").getNodeValue();
            int errors = Integer.parseInt(attributes.getNamedItem("errors").getNodeValue());
            int failures = Integer.parseInt(attributes.getNamedItem("failures").getNodeValue());
            String testName = testPkg != null && testPkg.length() != 0 ? testPkg + "." + testClass : testClass;
            Enumeration enumeration = resultFormatters.elements();
            while (enumeration.hasMoreElements()) {
                JUnitEEResultFormatter formatter = (JUnitEEResultFormatter)enumeration.nextElement();
                this.log("Calling formatter " + formatter + " for node " + node, 4);
                formatter.format(node);
                formatter.flush();
            }
            if (errors != 0) {
                if (test.getErrorproperty() != null) {
                    this.getProject().setNewProperty(test.getErrorproperty(), "true");
                }
                if (test.getHaltonerror() || test.getHaltonfailure()) {
                    throw new BuildException("Test " + testName + " failed.");
                }
            }
            if (failures == 0) continue;
            if (test.getFailureproperty() != null) {
                this.getProject().setNewProperty(test.getFailureproperty(), "true");
            }
            if (!test.getHaltonfailure()) continue;
            throw new BuildException("Test " + testName + " failed.");
        }
        NodeList errorMessages = root.getElementsByTagName("errorMessage");
        for (int i = 0; i < errorMessages.getLength(); ++i) {
            Node message = errorMessages.item(i);
            this.log(message.getFirstChild().getNodeValue(), 0);
        }
        if (errorMessages.getLength() != 0) {
            throw new BuildException("Test execution failed.");
        }
        return true;
    }

    private byte[] readInput(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        while ((r = in.read(buffer)) != -1) {
            out.write(buffer, 0, r);
        }
        return out.toByteArray();
    }

    private Vector createFormatters(JUnitEETest test) {
        FormatterElement element;
        Vector<JUnitEEResultFormatter> answer = new Vector<JUnitEEResultFormatter>();
        Enumeration enumeration = this.formatters.elements();
        while (enumeration.hasMoreElements()) {
            element = (FormatterElement)enumeration.nextElement();
            element.setOutFile(test.getOutfile());
            element.setFilterTrace(test.getFiltertrace());
            answer.add(element.createFormatter());
        }
        enumeration = test.getFormatters();
        while (enumeration.hasMoreElements()) {
            element = (FormatterElement)enumeration.nextElement();
            this.log("outfile=" + test.getOutfile(), 4);
            element.setOutFile(test.getOutfile());
            element.setFilterTrace(test.getFiltertrace());
            answer.add(element.createFormatter());
        }
        if (this.printSummary) {
            this.log("Adding summary formatter", 4);
            SummaryResultFormatter summary = new SummaryResultFormatter();
            summary.setOut(System.out);
            answer.add(summary);
        }
        this.log("Formatters: " + answer, 4);
        return answer;
    }
}

